PROGRAM test_quad
!
!  Purpose:
!    To test subroutine quad, which calculates the roots of 
!    a quadratic equation in a more robust fashion.
!
!  Record of revisions:
!      Date       Programmer          Description of change
!      ====       ==========          =====================
!    02/08/96    S. J. Chapman        Original code
!
IMPLICIT NONE

! List of variables:
REAL :: a             ! Coefficient of x**2
REAL :: b             ! Coefficient of x
REAL :: c             ! Constant coefficient
REAL :: x1            ! Root 1
REAL :: x2            ! Root 2
INTEGER :: error      ! Error flag: 0=no error
                      !             1=complex roots

! Prompt user and get the coefficients.
WRITE (*,1000)
1000 FORMAT (1X,'This program finds the roots of the quadratic ',/, &
             1X,'equation a*x**2 + b*x + c = 0.  Please enter ',/, &
             1X,'a, b, and c: ')
READ (*,*) a, b, c

! Get roots
CALL quad( a, b, c, x1, x2, error )

! Write results.
IF ( error == 0 ) THEN
   WRITE (*,*) 'The roots are: '
   WRITE (*,'(A,ES15.7)') '   x1 = ', x1
   WRITE (*,'(A,ES15.7)') '   x2 = ', x2
ELSE
   WRITE (*,'(A,I2)') ' Error in subroutine quad = ', error 
END IF

END PROGRAM
